/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.ClassMetrics;
import gr.spinellis.ckjm.ClassVisitor;
import gr.spinellis.ckjm.IClassMetricsContainer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public class MoaClassVisitor
extends EmptyVisitor {
    protected IClassMetricsContainer mMetricsContainer;
    private List<JavaClass> mClasses;

    public MoaClassVisitor(IClassMetricsContainer classMap) {
        this.mMetricsContainer = classMap;
        this.mClasses = new LinkedList<JavaClass>();
    }

    public void end() {
        for (JavaClass jc : this.mClasses) {
            this.countMoaInClass(jc);
        }
    }

    protected ClassMetrics getClassMetrics(String className) {
        return this.mMetricsContainer.getMetrics(className);
    }

    private void countMoaInClass(JavaClass currentClass) {
        Field[] fields = currentClass.getFields();
        int moa = 0;
        for (Field f : fields) {
            Iterator<JavaClass> itr = this.mClasses.iterator();
            while (itr.hasNext()) {
                String userClass = itr.next().getClassName();
                String fieldClass = ClassVisitor.className(f.getType());
                if (fieldClass.compareTo(userClass) != 0) continue;
                ++moa;
            }
        }
        this.getClassMetrics(currentClass.getClassName()).setMoa(moa);
    }

    public void visitJavaClass(JavaClass jc) {
        this.mClasses.add(jc);
    }
}

