/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm.ant;

import gr.spinellis.ckjm.CkjmOutputHandler;
import gr.spinellis.ckjm.ClassMetrics;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class PrintXmlResults
implements CkjmOutputHandler {
    private PrintStream p;
    private static String endl = System.getProperty("line.separator");

    public PrintXmlResults(PrintStream p) {
        this.p = p;
    }

    public void printHeader() {
        this.p.println("<?xml version=\"1.0\"?>");
        this.p.println("<ckjm>");
    }

    public void handleClass(String name, ClassMetrics c) {
        this.p.println("\t<class>");
        this.p.println("\t\t<name>" + name + "</name>");
        this.p.println("\t\t<wmc>" + c.getWmc() + "</wmc>");
        this.p.println("\t\t<dit>" + c.getDit() + "</dit>");
        this.p.println("\t\t<noc>" + c.getNoc() + "</noc>");
        this.p.println("\t\t<cbo>" + c.getCbo() + "</cbo>");
        this.p.println("\t\t<rfc>" + c.getRfc() + "</rfc>");
        this.p.println("\t\t<lcom>" + c.getLcom() + "</lcom>");
        this.p.println("\t\t<ca>" + c.getCa() + "</ca>");
        this.p.println("\t\t<ce>" + c.getCe() + "</ce>");
        this.p.println("\t\t<npm>" + c.getNpm() + "</npm>");
        this.p.println("\t\t<lcom3>" + c.getLcom3() + "</lcom3>");
        this.p.println("\t\t<loc>" + c.getLoc() + "</loc>");
        this.p.println("\t\t<dam>" + c.getDam() + "</dam>");
        this.p.println("\t\t<moa>" + c.getMoa() + "</moa>");
        this.p.println("\t\t<mfa>" + c.getMfa() + "</mfa>");
        this.p.println("\t\t<cam>" + c.getCam() + "</cam>");
        this.p.println("\t\t<ic>" + c.getIc() + "</ic>");
        this.p.println("\t\t<cbm>" + c.getCbm() + "</cbm>");
        this.p.println("\t\t<amc>" + c.getAmc() + "</amc>");
        this.p.println(this.printXmlCC(c));
        this.p.println("\t</class>");
    }

    public void printFooter() {
        this.p.println("</ckjm>");
    }

    private String printXmlCC(ClassMetrics cm) {
        StringBuffer xmlCC = new StringBuffer();
        List<String> methodNames = cm.getMethodNames();
        Iterator<String> itr = methodNames.iterator();
        xmlCC.append("\t\t<cc>" + endl);
        while (itr.hasNext()) {
            String name = itr.next();
            name = name.replaceAll("<|>", "_");
            xmlCC.append("\t\t\t<method name=\"" + name + "\">");
            xmlCC.append(cm.getCC(name));
            xmlCC.append("</method>" + endl);
        }
        xmlCC.append("\t\t</cc>");
        return xmlCC.toString();
    }
}

