/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm.ant;

import gr.spinellis.ckjm.MetricsFilter;
import gr.spinellis.ckjm.PrintPlainResults;
import gr.spinellis.ckjm.ant.PrintXmlResults;
import gr.spinellis.ckjm.utils.LoggerHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;

public class CkjmTask
extends MatchingTask {
    private File mOutputFile;
    private File mClassDir;
    private Path mExtdirs;
    private String mFormat = "plain";
    private String[] mJars;
    private boolean includeJDK = false;

    public void setFormat(String format) {
        this.mFormat = format;
    }

    public void setOutputfile(File outputfile) {
        this.mOutputFile = outputfile;
    }

    public void setClassdir(File classDir) {
        this.mClassDir = classDir;
    }

    public void setExtdirs(Path e) {
        if (this.mExtdirs == null) {
            this.mExtdirs = e;
        } else {
            this.mExtdirs.append(e);
        }
    }

    public Path getExtdirs() {
        return this.mExtdirs;
    }

    public Path createExtdirs() {
        if (this.mExtdirs == null) {
            this.mExtdirs = new Path(this.getProject());
        }
        return this.mExtdirs.createPath();
    }

    public void execute() throws BuildException {
        String[] files;
        if (this.getExtdirs() != null && this.getExtdirs().size() > 0) {
            if (System.getProperty("java.ext.dirs") == null || System.getProperty("java.ext.dirs").length() == 0) {
                System.setProperty("java.ext.dirs", this.mExtdirs.toString());
            } else {
                System.setProperty("java.ext.dirs", System.getProperty("java.ext.dirs") + File.pathSeparator + this.mExtdirs);
            }
            LoggerHelper.printWarning("You're using following java.ext.dirs: " + System.getProperty("java.ext.dirs"));
        }
        if ((files = this.mJars != null ? this.countJars() : this.countDirectory()).length == 0) {
            LoggerHelper.printError("No class files in specified location!");
        } else {
            try {
                FileOutputStream outputStream = new FileOutputStream(this.mOutputFile);
                if (this.mFormat.equals("xml")) {
                    PrintXmlResults outputXml = new PrintXmlResults(new PrintStream(outputStream));
                    outputXml.printHeader();
                    MetricsFilter.runMetrics(files, outputXml, this.includeJDK);
                    outputXml.printFooter();
                } else {
                    PrintPlainResults outputPlain = new PrintPlainResults(new PrintStream(outputStream));
                    MetricsFilter.runMetrics(files, outputPlain, this.includeJDK);
                }
                ((OutputStream)outputStream).close();
            }
            catch (IOException ioe) {
                throw new BuildException("Error file handling: " + ioe.getMessage());
            }
        }
    }

    public void setIncludeJDK(boolean includeJDK) {
        this.includeJDK = includeJDK;
    }

    public void setClassJars(String jars) {
        this.mJars = jars.split(":");
    }

    private String[] countDirectory() {
        if (this.mClassDir == null) {
            throw new BuildException("classdir attribute must be set!");
        }
        if (!this.mClassDir.exists()) {
            throw new BuildException("classdir does not exist!");
        }
        if (!this.mClassDir.isDirectory()) {
            throw new BuildException("classdir is not a directory!");
        }
        DirectoryScanner ds = super.getDirectoryScanner(this.mClassDir);
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            files[i] = this.mClassDir.getPath() + File.separatorChar + files[i];
        }
        return files;
    }

    private String[] countJars() {
        for (String name : this.mJars) {
            if (!name.toLowerCase().endsWith(".jar")) {
                throw new BuildException("Given jar file isn't in fact a jar file: " + name + "!");
            }
            File f = new File(name);
            if (!f.exists()) {
                throw new BuildException("Given jar file doesn't exist: " + name + "!");
            }
            if (f.isFile()) continue;
            throw new BuildException("Given jar file isn't in fact a jar file: " + name + "!");
        }
        return this.mJars;
    }
}

