/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.AbstractClassVisitor;
import gr.spinellis.ckjm.IClassMetricsContainer;
import gr.spinellis.ckjm.utils.FieldAccess;
import gr.spinellis.ckjm.utils.LoggerHelper;
import gr.spinellis.ckjm.utils.MethodCoupling;
import gr.spinellis.ckjm.utils.MethodInvokation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;

public class IcAndCbmClassVisitor
extends AbstractClassVisitor {
    private Method[] mMethods;
    private JavaClass mCurrentClass;
    private ConstantPoolGen mParentPool;
    private List<Method[]> mParentsMethods;
    private Set<MethodInvokation> mInvokationsFromParents;
    private Set<MethodInvokation> mInvoktionsFromCurrentClass;
    private Set<FieldAccess> mParentsReaders;
    private Set<FieldAccess> mCurrentClassSetters;
    private Set<MethodCoupling> mMethodCouplings;
    private JavaClass[] mParents;
    private JavaClass mParent;
    private String mParentClassName;
    private int mCase1;
    private int mCase2;
    private int mCase3;

    IcAndCbmClassVisitor(IClassMetricsContainer classMap) {
        super(classMap);
    }

    protected void visitJavaClass_body(JavaClass jc) {
        this.mCase3 = 0;
        this.mCase2 = 0;
        this.mCase1 = 0;
        this.mCurrentClass = jc;
        this.mParents = jc.getSuperClasses();
        this.mParentsMethods = new ArrayList<Method[]>();
        this.mMethods = jc.getMethods();
        this.mInvokationsFromParents = new TreeSet<MethodInvokation>();
        this.mInvoktionsFromCurrentClass = new TreeSet<MethodInvokation>();
        this.mParentsReaders = new TreeSet<FieldAccess>();
        this.mCurrentClassSetters = new TreeSet<FieldAccess>();
        this.mMethodCouplings = new TreeSet<MethodCoupling>();
        for (JavaClass javaClass : this.mParents) {
            this.mParentPool = new ConstantPoolGen(javaClass.getConstantPool());
            this.mParent = javaClass;
            this.mParentsMethods.add(javaClass.getMethods());
            for (Method m : javaClass.getMethods()) {
                m.accept(this);
            }
        }
        for (AccessFlags accessFlags : this.mMethods) {
            if (this.hasBeenDefinedInParentToo((Method)accessFlags)) {
                this.investigateMethod((Method)accessFlags);
            }
            this.investigateMethodAndLookForSetters((Method)accessFlags);
        }
        this.countCase1();
        this.countCase2();
        this.countCase3();
        this.saveResults();
    }

    public void visitMethod(final Method m) {
        MethodGen mg = new MethodGen(m, this.getParentClassName(), this.mParentPool);
        if (!mg.isAbstract() && !mg.isNative()) {
            for (InstructionHandle ih = mg.getInstructionList().getStart(); ih != null; ih = ih.getNext()) {
                Instruction i = ih.getInstruction();
                if (this.visitInstruction(i)) continue;
                i.accept(new EmptyVisitor(){

                    public void visitInvokeInstruction(InvokeInstruction ii) {
                        String methodName = "";
                        String className = "";
                        Type[] args = ii.getArgumentTypes(IcAndCbmClassVisitor.this.mParentPool);
                        methodName = ii.getMethodName(IcAndCbmClassVisitor.this.mParentPool);
                        className = ii.getClassName(IcAndCbmClassVisitor.this.mParentPool);
                        MethodInvokation mi = new MethodInvokation(className, methodName, args, IcAndCbmClassVisitor.this.getParentClassName(), m.getName(), m.getArgumentTypes());
                        IcAndCbmClassVisitor.this.mInvokationsFromParents.add(mi);
                    }

                    public void visitFieldInstruction(FieldInstruction fi) {
                        if (this.isGetInstruction(fi)) {
                            FieldAccess fa = new FieldAccess(fi.getFieldName(IcAndCbmClassVisitor.this.mParentPool), m, IcAndCbmClassVisitor.this.mParent);
                            IcAndCbmClassVisitor.this.mParentsReaders.add(fa);
                        }
                    }

                    private boolean isGetInstruction(FieldInstruction fi) {
                        String instr = fi.toString(IcAndCbmClassVisitor.this.mParentPool.getConstantPool());
                        return instr.startsWith("get");
                    }
                });
            }
        }
    }

    private boolean callsRedefinedMethod(MethodInvokation mi) {
        for (Method m : this.mMethods) {
            if (!this.isInvocationOfTheMethod(m, mi)) continue;
            mi.setDestClass(this.mClassName);
            return true;
        }
        return false;
    }

    private boolean compareTypes(Type[] args, Type[] args2) {
        boolean areEquals;
        boolean bl = areEquals = args.length == args2.length;
        if (areEquals) {
            for (int i = 0; i < args.length; ++i) {
                String miArgSignature = args2[i].getSignature();
                if (args[i].getSignature().equals(miArgSignature)) continue;
                areEquals = false;
                break;
            }
        }
        return areEquals;
    }

    private void countCase1() {
        block0: for (FieldAccess fap : this.mParentsReaders) {
            if (this.isFieldDefinedInCurrentClass(fap.getFieldName())) continue;
            for (FieldAccess fac : this.mCurrentClassSetters) {
                MethodCoupling mc;
                if (!fap.getFieldName().equals(fac.getFieldName()) || !this.mMethodCouplings.add(mc = new MethodCoupling(fap.getAccessorClass().getClassName(), fap.getAccessor().getName(), fac.getAccessorClass().getClassName(), fac.getAccessor().getName()))) continue;
                ++this.mCase1;
                continue block0;
            }
        }
    }

    private void countCase2() {
        for (MethodInvokation mi : this.mInvokationsFromParents) {
            MethodCoupling mc;
            if (!this.isFromParents(mi) || !mi.isNotConstructorInvocation() || !this.callsRedefinedMethod(mi) || !this.mMethodCouplings.add(mc = new MethodCoupling(mi.getDestClass(), mi.getDestMethod(), mi.getSrcClass(), mi.getSrcMethod()))) continue;
            ++this.mCase2;
        }
    }

    private void countCase3() {
        boolean isFromParents = false;
        for (MethodInvokation mi : this.mInvoktionsFromCurrentClass) {
            if (!mi.isNotConstructorInvocation() || this.isRedefinedInCurrentClass(mi)) continue;
            for (int i = 0; i < this.mParentsMethods.size(); ++i) {
                for (Method m : this.mParentsMethods.get(i)) {
                    isFromParents = this.isInvocationOfTheMethod(m, mi);
                    if (!isFromParents) continue;
                    mi.setDestClass(this.mParents[i].getClassName());
                    MethodCoupling mc = new MethodCoupling(mi.getDestClass(), mi.getDestMethod(), mi.getSrcClass(), mi.getSrcMethod());
                    if (this.mMethodCouplings.add(mc)) break;
                }
                if (isFromParents) break;
            }
            if (!isFromParents) continue;
            ++this.mCase3;
        }
    }

    private boolean equalMethods(Method m, Method pm) {
        return m.getName().equals(pm.getName()) && this.compareTypes(m.getArgumentTypes(), m.getArgumentTypes());
    }

    private void investigateMethod(final Method m) {
        MethodGen mg = new MethodGen(m, this.mClassName, this.mPoolGen);
        if (!mg.isAbstract() && !mg.isNative()) {
            for (InstructionHandle ih = mg.getInstructionList().getStart(); ih != null; ih = ih.getNext()) {
                Instruction i = ih.getInstruction();
                if (this.visitInstruction(i)) continue;
                i.accept(new EmptyVisitor(){

                    public void visitInvokeInstruction(InvokeInstruction ii) {
                        String methodName = "";
                        String className = "";
                        Type[] args = ii.getArgumentTypes(IcAndCbmClassVisitor.this.mPoolGen);
                        methodName = ii.getMethodName(IcAndCbmClassVisitor.this.mPoolGen);
                        className = ii.getClassName(IcAndCbmClassVisitor.this.mPoolGen);
                        if (args.length > 0) {
                            MethodInvokation mi = new MethodInvokation(className, methodName, args, IcAndCbmClassVisitor.this.mClassName, m.getName(), m.getArgumentTypes());
                            IcAndCbmClassVisitor.this.mInvoktionsFromCurrentClass.add(mi);
                        }
                    }
                });
            }
        }
    }

    private void investigateMethodAndLookForSetters(final Method m) {
        MethodGen mg = new MethodGen(m, this.mClassName, this.mPoolGen);
        if (!mg.isAbstract() && !mg.isNative()) {
            for (InstructionHandle ih = mg.getInstructionList().getStart(); ih != null; ih = ih.getNext()) {
                Instruction i = ih.getInstruction();
                if (this.visitInstruction(i)) continue;
                i.accept(new EmptyVisitor(){

                    public void visitFieldInstruction(FieldInstruction fi) {
                        if (this.isSetInstruction(fi)) {
                            FieldAccess fa = new FieldAccess(fi.getFieldName(IcAndCbmClassVisitor.this.mPoolGen), m, IcAndCbmClassVisitor.this.mCurrentClass);
                            IcAndCbmClassVisitor.this.mCurrentClassSetters.add(fa);
                        }
                    }

                    private boolean isSetInstruction(FieldInstruction fi) {
                        String instr = fi.toString(IcAndCbmClassVisitor.this.mCurrentClass.getConstantPool());
                        return instr.startsWith("put");
                    }
                });
            }
        }
    }

    private boolean isFieldDefinedInCurrentClass(String fieldName) {
        for (Field f : this.mCurrentClass.getFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private boolean isFromParents(MethodInvokation mi) {
        for (JavaClass jc : this.mParents) {
            if (!jc.getClassName().equals(mi.getDestClass())) continue;
            return true;
        }
        return false;
    }

    private boolean isInvocationOfTheMethod(Method m, MethodInvokation mi) {
        Type[] args;
        boolean areEquals;
        return m.getName().equals(mi.getDestMethod()) && (areEquals = this.compareTypes(args = m.getArgumentTypes(), mi.getDestMethodArgs()));
    }

    private boolean hasBeenDefinedInParentToo(Method m) {
        String name = m.getName();
        if (name.equals("<init>") || name.equals("<clinit>")) {
            return false;
        }
        for (Method[] parentMethods : this.mParentsMethods) {
            for (Method pm : parentMethods) {
                if (!this.equalMethods(m, pm)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRedefinedInCurrentClass(MethodInvokation mi) {
        for (Method m : this.mMethods) {
            if (!this.isInvocationOfTheMethod(m, mi)) continue;
            return true;
        }
        return false;
    }

    private void saveResults() {
        int sum = this.mCase1 + this.mCase2 + this.mCase3;
        this.mClassMetrics.setCbm(sum);
        TreeSet<String> coupledParents = new TreeSet<String>();
        for (MethodCoupling mc : this.mMethodCouplings) {
            if (mc.getClassA().equals(this.mClassName)) {
                coupledParents.add(mc.getClassB());
                if (!mc.getClassB().equals(this.mClassName)) continue;
                LoggerHelper.printError("Both of the involved in MethodCoupling classes are the investigated class!", new RuntimeException());
                continue;
            }
            coupledParents.add(mc.getClassA());
            if (mc.getClassB().equals(this.mClassName)) continue;
            LoggerHelper.printError("None  of the involved in MethodCoupling classes is the investigated class!", new RuntimeException());
        }
        this.mClassMetrics.setIc(coupledParents.size());
    }

    private boolean visitInstruction(Instruction i) {
        short opcode = i.getOpcode();
        return InstructionConstants.INSTRUCTIONS[opcode] != null;
    }

    private String getParentClassName() {
        return this.mParent.getClassName();
    }
}

