/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.utils.LoggerHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMetrics {
    private static final String endl = System.getProperty("line.separator");
    private static final String mLcomToHigh = "Value of LCOM3 cannot be set to more than 2.";
    private static final String mLcomToLow = "Value of LCOM3 cannot be set to less than 0.";
    private int mLoc;
    private int mWmc;
    private int mNoc;
    private int mRfc;
    private HashSet<String> mEfferentCoupledClasses = new HashSet();
    private int mDit;
    private int mLcom;
    private double mLcom3;
    private int mNpm;
    private boolean mVisited = false;
    private boolean mIsPublicClass;
    private HashSet<String> mAfferentCoupledClasses = new HashSet();
    private Map<String, Integer> mMapCyclomaticComlpexity = new HashMap<String, Integer>();
    private double mDam;
    private int mMoa;
    private double mMfa;
    private double mCam;
    private int mIc;
    private int mCBM;
    private double mAmc;

    public void addLoc(int a) {
        this.mLoc += a;
    }

    public int getLoc() {
        return this.mLoc;
    }

    public void incWmc() {
        ++this.mWmc;
    }

    public int getWmc() {
        return this.mWmc;
    }

    public void incNoc() {
        ++this.mNoc;
    }

    public int getNoc() {
        return this.mNoc;
    }

    public void setRfc(int r) {
        this.mRfc = r;
    }

    public int getRfc() {
        return this.mRfc;
    }

    public void setDit(int d) {
        this.mDit = d;
    }

    public int getDit() {
        return this.mDit;
    }

    public int getCbo() {
        HashSet<String> mCoupledClasses = new HashSet<String>();
        mCoupledClasses.addAll(this.mAfferentCoupledClasses);
        mCoupledClasses.addAll(this.mEfferentCoupledClasses);
        return mCoupledClasses.size();
    }

    public void setCe(HashSet<String> c) {
        this.mEfferentCoupledClasses = c;
    }

    public int getCe() {
        return this.mEfferentCoupledClasses.size();
    }

    public int getLcom() {
        return this.mLcom;
    }

    public void setLcom(int l) {
        this.mLcom = l;
    }

    public int getCa() {
        return this.mAfferentCoupledClasses.size();
    }

    public void addAfferentCoupling(String name) {
        this.mAfferentCoupledClasses.add(name);
    }

    public void incNpm() {
        ++this.mNpm;
    }

    public int getNpm() {
        return this.mNpm;
    }

    public boolean isPublic() {
        return this.mIsPublicClass;
    }

    public void setPublic() {
        this.mIsPublicClass = true;
    }

    public static boolean isJdkClass(String s) {
        return s.startsWith("java.") || s.startsWith("javax.") || s.startsWith("org.omg.") || s.startsWith("org.w3c.dom.") || s.startsWith("org.xml.sax.");
    }

    public String toString() {
        return this.getWmc() + " " + this.getDit() + " " + this.getNoc() + " " + this.getCbo() + " " + this.getRfc() + " " + this.getLcom() + " " + this.getCa() + " " + this.getCe() + " " + this.getNpm() + " " + String.format("%.4f", this.getLcom3()) + " " + this.getLoc() + " " + String.format("%.4f", this.getDam()) + " " + this.getMoa() + " " + String.format("%.4f", this.getMfa()) + " " + String.format("%.4f", this.getCam()) + " " + this.getIc() + " " + this.getCbm() + " " + String.format("%.4f", this.getAmc()) + endl + this.printPlainCC();
    }

    public void setVisited() {
        this.mVisited = true;
    }

    public boolean isVisited() {
        return this.mVisited;
    }

    public double getLcom3() {
        if (this.mLcom3 <= 0.0) {
            return 0.0;
        }
        return this.mLcom3;
    }

    public void setLcom3(double lcom3) {
        if (lcom3 < 0.0) {
            LoggerHelper.printError(mLcomToLow, new RuntimeException());
            lcom3 = 0.0;
        }
        if (lcom3 > 2.0) {
            LoggerHelper.printError(mLcomToHigh, new RuntimeException());
            lcom3 = 2.0;
        }
        this.mLcom3 = lcom3;
    }

    public List<String> getMethodNames() {
        LinkedList<String> methodNames = new LinkedList<String>();
        Set<String> mNames = this.mMapCyclomaticComlpexity.keySet();
        Iterator<String> itr = mNames.iterator();
        while (itr.hasNext()) {
            methodNames.add(itr.next());
        }
        return methodNames;
    }

    public int getCC(String key) {
        Integer i = this.mMapCyclomaticComlpexity.get(key);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public void addMethod(String signature, int cc) {
        if (signature == null) {
            return;
        }
        signature = signature.split("\n")[0];
        this.mMapCyclomaticComlpexity.put(signature, new Integer(cc));
    }

    public void setDam(double a) {
        this.mDam = a;
    }

    public double getDam() {
        return this.mDam;
    }

    private String printPlainCC() {
        StringBuffer plainCC = new StringBuffer();
        List<String> methodNames = this.getMethodNames();
        for (String name : methodNames) {
            plainCC.append(" ~ " + name + ": ");
            plainCC.append(this.getCC(name));
            plainCC.append(endl);
        }
        return plainCC.toString();
    }

    public int getMoa() {
        return this.mMoa;
    }

    public void setMoa(int a) {
        this.mMoa = a;
    }

    public double getMfa() {
        return this.mMfa;
    }

    public void setMfa(double mfa) {
        this.mMfa = mfa;
    }

    public double getCam() {
        return this.mCam;
    }

    public void setCam(double cam) {
        this.mCam = cam;
    }

    public int getIc() {
        return this.mIc;
    }

    public void setIc(int Ic) {
        this.mIc = Ic;
    }

    public int getCbm() {
        return this.mCBM;
    }

    public void setCbm(int mCBM) {
        this.mCBM = mCBM;
    }

    public double getAmc() {
        return this.mAmc;
    }

    public void setAmc(double mAmc) {
        this.mAmc = mAmc;
    }
}

