/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm.utils;

import gr.spinellis.ckjm.utils.LoggerHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLineParser {
    private Set<String> args;
    List<String> classes;

    public void parse(String[] argv) {
        this.args = new HashSet<String>();
        this.classes = new ArrayList<String>();
        for (String s : argv) {
            if (s.startsWith("-")) {
                for (int i = 1; i < s.length(); ++i) {
                    this.args.add(s.substring(i, i + 1));
                }
                continue;
            }
            this.addClass(s);
        }
        if (this.classes.isEmpty()) {
            this.readClassesFromStdio();
        }
    }

    private void addClass(String colonSeparatedNames) {
        String[] names = colonSeparatedNames.split(";");
        this.classes.addAll(Arrays.asList(names));
    }

    public boolean isArgSet(String arg) {
        return this.args.contains(arg);
    }

    public List<String> getClassNames() {
        return this.classes;
    }

    private void readClassesFromStdio() {
        System.out.println("Please enter fully qualified names of the java classes to analyse.");
        System.out.println("Each class should be entered in separate line.");
        System.out.println("After the last class press enter to continue.");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            String s;
            while ((s = in.readLine()) != null && s.length() > 0) {
                this.addClass(s);
            }
        }
        catch (Exception e) {
            LoggerHelper.printError("Error reading line: " + e);
            System.exit(1);
        }
    }
}

