/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm.utils;

import gr.spinellis.ckjm.utils.LoggerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCoupling
implements Comparable<MethodCoupling> {
    private String mClassA;
    private String mClassB;
    private String mMethodA;
    private String mMethodB;

    public MethodCoupling(String classA, String methodA, String classB, String methodB) {
        this.mClassA = classA;
        this.mMethodA = methodA;
        this.mClassB = classB;
        this.mMethodB = methodB;
        if (classA.equals(classB) && methodA.equals(methodB)) {
            LoggerHelper.printError("Method " + classA + "." + methodA + " is coupled to itself!", new RuntimeException());
        } else if (classA.equals(classB)) {
            LoggerHelper.printError("Coupling within methods in the same class (" + classA + "): " + methodA + " is coupled to " + methodB + "!", new RuntimeException());
        }
    }

    public String toString() {
        return this.mClassA + "." + this.mMethodA + " is coupled to " + this.mClassB + "." + this.mMethodB;
    }

    @Override
    public int compareTo(MethodCoupling mc) {
        int res = 0;
        res = this.mClassA.compareTo(mc.getClassB());
        res += this.mClassB.compareTo(mc.getClassA());
        res += this.mMethodA.compareTo(mc.getMethodB());
        if ((res += this.mMethodB.compareTo(mc.getMethodA())) == 0) {
            return res;
        }
        res = this.mClassA.compareTo(mc.getClassA());
        res += this.mClassB.compareTo(mc.getClassB());
        res += this.mMethodA.compareTo(mc.getMethodA());
        return res += this.mMethodB.compareTo(mc.getMethodB());
    }

    public String getClassA() {
        return this.mClassA;
    }

    public String getClassB() {
        return this.mClassB;
    }

    public String getMethodA() {
        return this.mMethodA;
    }

    public String getMethodB() {
        return this.mMethodB;
    }
}

