/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm.ant;

import gr.spinellis.ckjm.CkjmOutputHandler;
import gr.spinellis.ckjm.ClassMetrics;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class PrintXmlResults
implements CkjmOutputHandler {
    private PrintStream p;
    private static String endl = System.getProperty("line.separator");

    public PrintXmlResults(PrintStream p) {
        this.p = p;
    }

    public void printHeader() {
        this.p.println("<?xml version=\"1.0\"?>");
        this.p.println("<ckjm>");
    }

    public void handleClass(String name, ClassMetrics c) {
        this.p.println("<class>");
        this.p.println("<name>" + name + "</name>");
        this.p.println("<wmc>" + c.getWmc() + "</wmc>");
        this.p.println("<dit>" + c.getDit() + "</dit>");
        this.p.println("<noc>" + c.getNoc() + "</noc>");
        this.p.println("<cbo>" + c.getCbo() + "</cbo>");
        this.p.println("<rfc>" + c.getRfc() + "</rfc>");
        this.p.println("<lcom>" + c.getLcom() + "</lcom>");
        this.p.println("<ca>" + c.getCa() + "</ca>");
        this.p.println("<ce>" + c.getCe() + "</ce>");
        this.p.println("<npm>" + c.getNpm() + "</npm>");
        this.p.println("<lcom3>" + c.getLcom3() + "</lcom3>");
        this.p.println("<loc>" + c.getLoc() + "</loc>");
        this.p.println("<dam>" + c.getDam() + "</dam>");
        this.p.println("<moa>" + c.getMoa() + "</moa>");
        this.p.println("<mfa>" + c.getMfa() + "</mfa>");
        this.p.println("<cam>" + c.getCam() + "</cam>");
        this.p.println("<ic>" + c.getIc() + "</ic>");
        this.p.println("<cbm>" + c.getCbm() + "</cbm>");
        this.p.println("<amc>" + c.getAmc() + "</amc>");
        this.p.println(this.printXmlCC(c));
        this.p.println("</class>");
    }

    public void printFooter() {
        this.p.println("</ckjm>");
    }

    private String printXmlCC(ClassMetrics cm) {
        StringBuffer xmlCC = new StringBuffer();
        List<String> methodNames = cm.getMethodNames();
        Iterator<String> itr = methodNames.iterator();
        xmlCC.append("<cc>" + endl);
        while (itr.hasNext()) {
            String name = itr.next();
            name = name.replaceAll("<|>", "_");
            xmlCC.append("<method name=\"" + name + "\">");
            xmlCC.append(cm.getCC(name));
            xmlCC.append("</method>" + endl);
        }
        xmlCC.append("</cc>");
        return xmlCC.toString();
    }
}

