/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.ClassMetrics;
import gr.spinellis.ckjm.ClassVisitor;
import gr.spinellis.ckjm.TreeSetWithId;
import org.apache.bcel.generic.ArrayInstruction;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.FieldOrMethod;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodVisitor
extends EmptyVisitor {
    private MethodGen mg;
    private ConstantPoolGen cp;
    private ClassVisitor cv;
    private ClassMetrics cm;
    private TreeSetWithId<String> mm = new TreeSetWithId();

    MethodVisitor(MethodGen m, ClassVisitor c) {
        this.mg = m;
        this.cv = c;
        this.cp = this.mg.getConstantPool();
        this.cm = this.cv.getMetrics();
        this.cm.addMethod(this.mg.toString(), 1);
    }

    public void start() {
        if (!this.mg.isAbstract() && !this.mg.isNative()) {
            for (InstructionHandle ih = this.mg.getInstructionList().getStart(); ih != null; ih = ih.getNext()) {
                Instruction i = ih.getInstruction();
                if (this.visitInstruction(i)) continue;
                i.accept(this);
            }
            this.updateExceptionHandlers();
        }
    }

    private boolean visitInstruction(Instruction i) {
        short opcode = i.getOpcode();
        return InstructionConstants.INSTRUCTIONS[opcode] != null && !(i instanceof ConstantPushInstruction) && !(i instanceof ReturnInstruction);
    }

    @Override
    public void visitBranchInstruction(BranchInstruction obj) {
        String instruction = obj.toString();
        String method = this.mg.toString();
        int oldValue = this.cm.getCC(method);
        if (instruction.contains("lookupswitch")) {
            char[] instr = instruction.toCharArray();
            int numb = 0;
            for (int i = 0; i < instr.length; ++i) {
                if (instr[i] != '[') continue;
                ++numb;
            }
            this.cm.addMethod(method, oldValue + numb);
        } else if (!instruction.contains("goto")) {
            this.cm.addMethod(method, oldValue + 1);
        }
    }

    @Override
    public void visitLocalVariableInstruction(LocalVariableInstruction i) {
        if (i.getOpcode() != 132) {
            this.cv.registerCoupling(i.getType(this.cp));
        }
    }

    @Override
    public void visitArrayInstruction(ArrayInstruction i) {
        this.cv.registerCoupling(i.getType(this.cp));
    }

    @Override
    public void visitFieldInstruction(FieldInstruction i) {
        this.cv.registerFieldAccess(i.getClassName(this.cp), i.getFieldName(this.cp));
        this.cv.registerCoupling(i.getFieldType(this.cp));
    }

    @Override
    public void visitInvokeInstruction(InvokeInstruction i) {
        Type[] argTypes = i.getArgumentTypes(this.cp);
        for (int j = 0; j < argTypes.length; ++j) {
            this.cv.registerCoupling(argTypes[j]);
        }
        this.cv.registerCoupling(i.getReturnType(this.cp));
        this.cv.registerMethodInvocation(i.getClassName(this.cp), i.getMethodName(this.cp), argTypes);
    }

    @Override
    public void visitINSTANCEOF(INSTANCEOF i) {
        this.cv.registerCoupling(i.getType(this.cp));
    }

    @Override
    public void visitCHECKCAST(CHECKCAST i) {
        this.cv.registerCoupling(i.getType(this.cp));
    }

    @Override
    public void visitReturnInstruction(ReturnInstruction i) {
        this.cv.registerCoupling(i.getType(this.cp));
    }

    private void updateExceptionHandlers() {
        CodeExceptionGen[] handlers = this.mg.getExceptionHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            ObjectType t = handlers[i].getCatchType();
            if (t == null) continue;
            this.cv.registerCoupling(t);
        }
    }

    @Override
    public void visitFieldOrMethod(FieldOrMethod obj) {
        if (obj.getName().startsWith("invoke") && obj.getClassName(this.cp).equals(this.cv.getMyClassName())) {
            this.mm.add(obj.getName(this.cp) + obj.getSignature(this.cp));
        }
    }

    public TreeSetWithId<String> getMethodsNames() {
        return this.mm;
    }
}

