/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.AbstractClassVisitor;
import gr.spinellis.ckjm.ClassMetrics;
import gr.spinellis.ckjm.IClassMetricsContainer;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamClassVisitor
extends AbstractClassVisitor {
    private final String mThis = "this";

    public CamClassVisitor(IClassMetricsContainer container) {
        super(container);
    }

    private Set<String> getArgsTypes(Method m, JavaClass jc, ConstantPoolGen poolGen) {
        Type[] args;
        HashSet<String> result = new HashSet<String>();
        if (this.ignore(m)) {
            return result;
        }
        if (!m.isStatic()) {
            result.add("this");
        }
        MethodGen mg = new MethodGen(m, jc.getClassName(), poolGen);
        for (Type t : args = mg.getArgumentTypes()) {
            result.add(t.getSignature());
        }
        return result;
    }

    protected ClassMetrics getClassMetrics(JavaClass jc) {
        return this.mMetricsContainer.getMetrics(jc.getClassName());
    }

    private boolean ignore(Method m) {
        return m.getName().compareTo("<clinit>") == 0;
    }

    @Override
    protected void visitJavaClass_body(JavaClass jc) {
        ConstantPoolGen poolGen = new ConstantPoolGen(jc.getConstantPool());
        HashSet<String> types = new HashSet<String>();
        Method[] methods = jc.getMethods();
        double numerator = 0.0;
        double denominator = 0.0;
        for (Method m : methods) {
            types.addAll(this.getArgsTypes(m, jc, poolGen));
        }
        for (Method m : methods) {
            if (this.ignore(m)) continue;
            numerator += (double)this.getArgsTypes(m, jc, poolGen).size();
            denominator += (double)types.size();
        }
        if (denominator == 0.0) {
            denominator = 1.0;
        }
        this.getClassMetrics(jc).setCam(numerator / denominator);
    }
}

