/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.ClassMetrics;
import gr.spinellis.ckjm.IClassMetricsContainer;
import gr.spinellis.ckjm.ICountingProperities;
import gr.spinellis.ckjm.MethodVisitor;
import gr.spinellis.ckjm.TreeSetWithId;
import gr.spinellis.ckjm.utils.LoggerHelper;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVisitor
extends EmptyVisitor {
    private ICountingProperities mProp = null;
    private JavaClass mVisitedClass;
    private ConstantPoolGen mPoolGen;
    private String mMyClassName;
    private IClassMetricsContainer mClassMetricsContainer;
    private ClassMetrics mClassMetrics;
    private HashSet<String> mEfferentCoupledClasses = new HashSet();
    private HashSet<String> mResponseSet = new HashSet();
    ArrayList<TreeSetWithId<String>> mFieldsUsedByMethods = new ArrayList();
    private ArrayList<TreeSetWithId<String>> mMethodsUsedByMethods = new ArrayList();
    private Field[] mFields;

    public ClassVisitor(JavaClass jc, IClassMetricsContainer classMap, ICountingProperities prop) {
        if (prop == null) {
            throw new RuntimeException("CountingProperties cannot be null");
        }
        this.mProp = prop;
        this.mVisitedClass = jc;
        this.mPoolGen = new ConstantPoolGen(this.mVisitedClass.getConstantPool());
        this.mClassMetricsContainer = classMap;
        this.mMyClassName = jc.getClassName();
        this.mClassMetrics = this.mClassMetricsContainer.getMetrics(this.getMyClassName());
    }

    public Field[] getFields() {
        return this.mFields;
    }

    public ClassMetrics getMetrics() {
        return this.mClassMetrics;
    }

    public void start() {
        this.visitJavaClass(this.mVisitedClass);
    }

    @Override
    public void visitJavaClass(JavaClass jc) {
        int i;
        String super_name = jc.getSuperclassName();
        String package_name = jc.getPackageName();
        this.mClassMetrics.setVisited();
        if (jc.isPublic()) {
            this.mClassMetrics.setPublic();
        }
        ClassMetrics pm = this.mClassMetricsContainer.getMetrics(super_name);
        pm.incNoc();
        this.mClassMetrics.setDit(jc.getSuperClasses().length);
        this.registerCoupling(super_name);
        String[] ifs = jc.getInterfaceNames();
        for (i = 0; i < ifs.length; ++i) {
            this.registerCoupling(ifs[i]);
        }
        this.mFields = jc.getFields();
        for (i = 0; i < this.mFields.length; ++i) {
            this.mFields[i].accept(this);
        }
        Method[] methods = jc.getMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            methods[i2].accept(this);
        }
    }

    public void registerCoupling(String className) {
        if (!(!this.mProp.isJdkIncluded() && ClassMetrics.isJdkClass(className) || this.getMyClassName().equals(className))) {
            this.mEfferentCoupledClasses.add(className);
            this.mClassMetricsContainer.getMetrics(className).addAfferentCoupling(this.getMyClassName());
        }
    }

    public void registerCoupling(Type t) {
        this.registerCoupling(ClassVisitor.className(t));
    }

    void registerFieldAccess(String className, String fieldName) {
        this.registerCoupling(className);
        if (className.equals(this.getMyClassName())) {
            this.mFieldsUsedByMethods.get(this.mFieldsUsedByMethods.size() - 1).add(fieldName);
        }
    }

    void registerMethodInvocation(String className, String methodName, Type[] args) {
        this.registerCoupling(className);
        this.incRFC(className, methodName, args);
    }

    @Override
    public void visitField(Field field) {
        this.registerCoupling(field.getType());
    }

    private void incRFC(String className, String methodName, Type[] arguments) {
        String argumentList = Arrays.asList(arguments).toString();
        String args = argumentList.substring(1, argumentList.length() - 1);
        String signature = className + "." + methodName + "(" + args + ")";
        this.mResponseSet.add(signature);
    }

    @Override
    public void visitMethod(Method method) {
        MethodGen mg = new MethodGen(method, this.mVisitedClass.getClassName(), this.mPoolGen);
        Type result_type = mg.getReturnType();
        Type[] argTypes = mg.getArgumentTypes();
        this.registerCoupling(mg.getReturnType());
        for (int i = 0; i < argTypes.length; ++i) {
            this.registerCoupling(argTypes[i]);
        }
        String[] exceptions = mg.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            this.registerCoupling(exceptions[i]);
        }
        this.incRFC(this.getMyClassName(), method.getName(), argTypes);
        this.mClassMetrics.incWmc();
        if (Modifier.isPublic(method.getModifiers())) {
            this.mClassMetrics.incNpm();
        }
        TreeSetWithId<Object> ntree = new TreeSetWithId();
        ntree.setId(mg.getName() + mg.getSignature());
        this.mFieldsUsedByMethods.add(ntree);
        MethodVisitor factory = new MethodVisitor(mg, this);
        factory.start();
        ntree = factory.getMethodsNames();
        ntree.setId(mg.getName() + mg.getSignature());
        this.mMethodsUsedByMethods.add(ntree);
    }

    static String className(Type t) {
        String ts = t.toString();
        if (t.getType() <= 12) {
            return "java.PRIMITIVE";
        }
        if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            return ClassVisitor.className(at.getBasicType());
        }
        return t.toString();
    }

    public void end() {
        this.mClassMetrics.setCe(this.mEfferentCoupledClasses);
        this.mClassMetrics.setRfc(this.mResponseSet.size());
        int lcom = 0;
        for (int i = 0; i < this.mFieldsUsedByMethods.size(); ++i) {
            for (int j = i + 1; j < this.mFieldsUsedByMethods.size(); ++j) {
                TreeSet intersection = (TreeSet)this.mFieldsUsedByMethods.get(i).clone();
                intersection.retainAll((Collection)this.mFieldsUsedByMethods.get(j));
                if (intersection.size() == 0) {
                    ++lcom;
                    continue;
                }
                --lcom;
            }
        }
        this.mClassMetrics.setLcom(lcom > 0 ? lcom : 0);
        this.countLcom3();
    }

    private void countLcom3() {
        double lcom3 = 2.0;
        int m = 0;
        if (this.mFieldsUsedByMethods != null) {
            m = this.mFieldsUsedByMethods.size();
        }
        int a = 0;
        if (this.mFields != null) {
            a = this.mFields.length;
        }
        int arc = 0;
        if (m != 0 && m != 1 && a != 0) {
            for (int i = 0; i < m; ++i) {
                Lcom3Counter lcom3c = new Lcom3Counter(this.removeInheritedFields((TreeSet<String>)this.mFieldsUsedByMethods.get(i)), this.mFieldsUsedByMethods.get(i).getId(), this.mFieldsUsedByMethods);
                lcom3c.findUsedFields(this.mFieldsUsedByMethods.get(i).getId());
                arc += lcom3c.getFieldsNames().size();
            }
            lcom3 = (double)arc / (double)a - (double)m;
            lcom3 /= (double)(1 - m);
        }
        try {
            this.mClassMetrics.setLcom3(lcom3);
        }
        catch (RuntimeException e) {
            LoggerHelper.printError("Exception in class " + this.getMyClassName() + ": " + e, e);
        }
    }

    TreeSet<String> removeInheritedFields(TreeSet<String> treeWithFields) {
        if (treeWithFields == null) {
            return null;
        }
        Iterator<String> itr = treeWithFields.iterator();
        while (itr.hasNext()) {
            String fieldName = itr.next();
            boolean remove = true;
            for (int index = 0; index < this.mFields.length; ++index) {
                if (this.mFields[index].getName().compareTo(fieldName) != 0) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            itr.remove();
        }
        return treeWithFields;
    }

    public String getMyClassName() {
        return this.mMyClassName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Lcom3Counter {
        private TreeSet<String> mFieldsNames;
        TreeSet<String> mMethodsNames;
        ArrayList<TreeSetWithId<String>> mFieldsUsedByMethods;

        Lcom3Counter(TreeSet<String> ts, String method, ArrayList<TreeSetWithId<String>> fieldsUsedByMethods) {
            this.mFieldsNames = ts;
            this.mMethodsNames = new TreeSet();
            this.mMethodsNames.add(method);
            this.mFieldsUsedByMethods = fieldsUsedByMethods;
        }

        void findUsedFields(String method) {
            TreeSet<String> invokedMethods = this.getInvokedMethodsByMethodName(method);
            if (invokedMethods != null) {
                for (String name : invokedMethods) {
                    TreeSet<String> fields = ClassVisitor.this.removeInheritedFields(this.getUsedFieldsByMethodName(name));
                    if (fields == null) continue;
                    this.mFieldsNames.addAll(fields);
                }
            }
        }

        TreeSet<String> getFieldsNames() {
            return this.mFieldsNames;
        }

        private TreeSet<String> getUsedFieldsByMethodName(String name) {
            return this.getByMethodName(name, this.mFieldsUsedByMethods);
        }

        private TreeSet<String> getInvokedMethodsByMethodName(String name) {
            return this.getByMethodName(name, ClassVisitor.this.mMethodsUsedByMethods);
        }

        private TreeSet<String> getByMethodName(String name, ArrayList<TreeSetWithId<String>> m) {
            for (int i = 0; i < m.size(); ++i) {
                if (m.get(i).getId().compareTo(name) != 0) continue;
                return m.get(i);
            }
            return null;
        }
    }
}

